/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.common.recipe.BottlerRecipe;
import cy.jdkdigital.productivebees.common.recipe.TagOutputRecipe;
import cy.jdkdigital.productivebees.init.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BottlerRecipeCategory
implements IRecipeCategory<BottlerRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("productivebees", "bottler");
    private final IDrawable icon;
    private final IDrawable background;

    public BottlerRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bottler_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.BOTTLER.get()));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends BottlerRecipe> getRecipeClass() {
        return BottlerRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.productivebees.bottler");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BottlerRecipe recipe, List<? extends IFocus<?>> focuses) {
        List<Fluid> fluids = TagOutputRecipe.getAllFluidsFromName((String)recipe.fluidInput.getFirst());
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        for (Fluid fluid : fluids) {
            fluidStacks.add(new FluidStack(fluid, ((Integer)recipe.fluidInput.getSecond()).intValue()));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 9, 27).addIngredients(VanillaTypes.FLUID, fluidStacks)).setSlotName("inputFluid");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 43, 27).addItemStacks(Arrays.stream(recipe.itemInput.m_43908_()).toList())).setSlotName("inputItem");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 27).addItemStack(recipe.result)).setSlotName("result");
    }
}

